/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.config;

import cofh.lib.config.IBaseConfig;
import cofh.lib.config.world.OreConfig;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;

public class ThermalWorldConfig
implements IBaseConfig {
    protected static final Map<String, OreConfig> ORE_CONFIGS = new Object2ObjectOpenHashMap();

    public static void addOreConfig(String name, OreConfig config) {
        ORE_CONFIGS.put(name, config);
    }

    public static OreConfig getOreConfig(String name) {
        return ORE_CONFIGS.getOrDefault(name, OreConfig.EMPTY_CONFIG);
    }

    public void apply(ForgeConfigSpec.Builder builder) {
        builder.push("World");
        builder.push("Ores");
        for (IBaseConfig iBaseConfig : ORE_CONFIGS.values()) {
            iBaseConfig.apply(builder);
        }
        builder.pop();
        builder.pop();
    }

    public void refresh() {
        for (IBaseConfig iBaseConfig : ORE_CONFIGS.values()) {
            iBaseConfig.refresh();
        }
    }
}

